/*
 * ServerThread.java
 *
 * 
 */
package	DisCSP.DistributedCSP;

import java.io.*;
import java.net.*;
import DisCSP.CSP.*;
import DisCSP.CSPLexerParser.*;
import DisCSP.DistributedCSP.ExternalConstraint.*;
import DisCSP.Exception.*;
import java.util.Vector;

/**
 * @ version 1.0
 *
 * @ author Nocerino Francesca
 *
 * @ since JDK 1.4
 *
 */


class ServerThread extends Thread
{

	private Socket socket;
	private BufferedReader in;
	private PrintWriter out;
	private DisConstraintProblem disConstrProbl;
	private Neighbourhood nhood;
	private AgentState state;
	private PrintStream streamOut;

 	/** Costruttore di ServerThread
     * 
     * @param s la socket
     * @param dis il problema associato all'agente
     * @param n i vicini dell' agente
     * @param st lo stato dell'agente
     * @param o il PrintStream su cui direzionare l'output
     * 
     */		
	
	public ServerThread(Socket s,DisConstraintProblem dis,Neighbourhood n,AgentState st,PrintStream o) throws IOException
	{
		streamOut=o;
		disConstrProbl=dis;
		state=st;
		socket = s;
		in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
		OutputStreamWriter osw = new OutputStreamWriter(socket.getOutputStream());
		out = new PrintWriter(new BufferedWriter(osw), true);
		start(); 
		nhood=n;		
	}

	
	 /** Metodo run del Thread
     * 
     * 
     */		
	public void run()
	{
	synchronized(state)
	{
	
		
		try
		{
    	   	String str=null;
    	   	while (str==null)
    		{
    			 str = in.readLine();
    		}
    	
    		
    			
			String[] mess=str.split(" ");
			socket.close();
			
			if (mess[0].equals("arc_information")&&!state.impossible()&&!state.consistent())
			{
					streamOut.println(state.getName()+" "+" received "+str);
					boolean sent=false;
					try
					{
						state.setWaiting(false);
						for(int j=0;j<nhood.size();j++)
						{
							Neighbour neighApp=nhood.neighbourAt(j);
							if(mess[mess.length-2].equals(neighApp.addressString()) && mess[mess.length-1].equals(""+neighApp.port() ) )
							{
									neighApp.incrReceivedFrom();
									break;
							}	
						}

						String[] mod=processArcInformation(mess,disConstrProbl);
						
						Vector modVect=new Vector();
						
						for(int i=0;i<mod.length;i++)
						{
							modVect.add(mod[i]);
						}
						
						for(int j=0;j<nhood.size();j++)
						{
							Neighbour neighApp=nhood.neighbourAt(j);
							String info="arc_information "; 
							Vector appName=new Vector();
					
							for(int k=0;k<neighApp.relatedVariables();k++)
							{
			
								for(int i=0;i<disConstrProbl.numberOfExternalConstraint();i++)
								{							
									ExtBinaryConstraint extApp=disConstrProbl.externalConstraintAt(i);
									
									if(extApp.getExternalVariable().equals(neighApp.variableAt(k) ) )
									{										
										if(modVect.contains(extApp.getLocalVariable().getName()) )
										{
											String name=extApp.getLocalVariable().getName();
											if(!appName.contains(name))
											{
												info+=name+" ";
												String dom=extApp.getLocalVariable().printDomain();
												info+=dom;
												info+=" ";								
												appName.add(name);
											}		
										}
					
									}						
				
								}
							
							}
													
							if(!info.equals("arc_information ") )
							{
								info+=state.address();
								info+=" ";
								info+=state.port();
								sendInformation(info,neighApp.address(),neighApp.port());
								sent=true;
								neighApp.incrSentTo();
							}
							
						}
				
						state.setWaiting(true);
					
					
						if(!sent&&!state.impossible()&&!state.consistent())
						{
							for(int j=0;j<nhood.size();j++)
							{
								Neighbour neighApp=nhood.neighbourAt(j);
								sendMarker(neighApp.address(),neighApp.port(),neighApp.receivedFrom(),state.address(),""+state.port(),""+state.initiative() );
							}
	
							
							 sendMonitor("arc_first_waiting "+state.address()+" "+state.port()+" "+state.initiative(), state.address(),""+state.port(),""+state.initiative()); 
							 state.incrInitiative();
						}
					}
				
					catch (NoSolutionException e)
					{
						if(!state.impossible())
						{											
							state.setImpossible(true);
																				
							for(int j=0;j<nhood.size();j++)
							{
								Neighbour neighApp=nhood.neighbourAt(j);
								sendNoSolution(neighApp.address(),neighApp.port());
							}
							sendNoSolution(state.monitorAddr(),state.monitorPort());
							streamOut.println(state.getName()+" "+"I understood there is no solution.");
							lastConnection();
						}
					}
					catch (Exception e)
					{
					}				
			}

			if (mess[0].equals("arc_consistency"))
			{						
				streamOut.println(state.getName()+" "+"ARC-CONSISTENCY!\n"+disConstrProbl.print());
				state.setConsistent(true);
				lastConnection();
			}
			
			//arc_marker num_ricevuti addr port
			
			if (mess[0].equals("arc_marker")&&!state.impossible()&&!state.consistent())
			{						
					if(!state.receivedMarker(mess[4]+" "+mess[5]+" "+mess[6]))
					{		
						state.insertMarker(mess[4]+" "+mess[5]+" "+mess[6]);
						
						int ric=new Integer( mess[1] ).intValue();
												
						for(int j=0;j<nhood.size();j++)
						{
							Neighbour neighApp=nhood.neighbourAt(j);
							if(mess[2].equals(neighApp.addressString()) && mess[3].equals(""+neighApp.port() ) )
							{
									if(neighApp.sentTo()==ric)
									{
										if( state.waiting() )  sendMonitor("arc_waiting",mess[4],mess[5],mess[6]);
										else sendMonitor("arc_not_waiting",mess[4],mess[5],mess[6]);
									}
									else
									{
										sendMonitor("arc_message_travelling",mess[4],mess[5],mess[6]);
									}	
							}
						}
						for(int j=0;j<nhood.size();j++)
						{
							Neighbour neighApp=nhood.neighbourAt(j);
						//	if(!(mess[2].equals(neighApp.addressString()) && mess[3].equals(""+neighApp.port()) ) )
						//	{
								sendMarker(neighApp.address(),neighApp.port(),neighApp.receivedFrom(),mess[4],mess[5],mess[6]);
						//	}
						}
					}
			
			}

			if (mess[0].equals("arc_no_solution"))
			{						
				
				if(!state.impossible())
				{											
					state.setImpossible(true);
					for(int j=0;j<nhood.size();j++)
					{
						Neighbour neighApp=nhood.neighbourAt(j);
						sendNoSolution(neighApp.address(),neighApp.port());
					}
					streamOut.println(state.getName()+" "+"An agent told me there is no solution.");
					lastConnection();
				}
			}
								
			
		}	
		catch (IOException e)
		{
		}
		
		
	}
	}
	
	private String[] processArcInformation(String[] mess, DisConstraintProblem dCP ) throws   ParserException,
																									LexerException,
																									ExistentVarException,
																									NoSolutionException,
																									UnknownVariableException,
																									NotBinaryConstrException
	{
		synchronized(dCP)
		{
			int len=mess.length-3;
			Variable[] varsApp= new Variable[(len/2)];
			
			for(int i=0;i<(len/2);i++ )
			{
				varsApp[i]=new Variable(mess[(2*i+1)],new Parser(new Lexer(mess[(2*i+2)])).parseDomain());
				dCP.addVariable(varsApp[i]);
				for(int j=0;j<dCP.numberOfExternalConstraint();j++)
				{
					if(dCP.externalConstraintAt(j).getExternalVariable().equals(mess[(2*i+1)]))
					{
						dCP.addConstraint(dCP.externalConstraintAt(j),varsApp[i]);
					}
				}
					
			}
			
			PropagationAlgorithm propAlg=new PropagationAlgorithm();
			
			
			String[] ris=propAlg.arc_consistency(dCP.localConstraintProblem());
			
					
			for(int i=0;i<(len/2);i++ )
			{
				dCP.removeVariable(varsApp[i]);					
			}
						
			return ris;
			
		}
	}
	
	
	private void sendInformation(String message,InetAddress addr, int p)
	{
		Socket socket;
		BufferedReader in;
		PrintWriter out;
		
		try
		{
			socket = new Socket(addr, p);
						
			InputStreamReader isr = new InputStreamReader(socket.getInputStream());
			in = new BufferedReader(isr);
			OutputStreamWriter osw = new OutputStreamWriter(socket.getOutputStream());
			out = new PrintWriter(new BufferedWriter(osw), true);
			out.println(message);
			
			streamOut.println(state.getName()+" "+"Sent "+message);
				
			socket.close();
						
		}

	    catch(Exception e)
	    {
	    }
	    	    
	}
	
	private void sendNoSolution(InetAddress addr, int p)
	{
		Socket socket;
		BufferedReader in;
		PrintWriter out;
		
		try
		{
			socket = new Socket(addr, p);
						
			InputStreamReader isr = new InputStreamReader(socket.getInputStream());
			in = new BufferedReader(isr);
			OutputStreamWriter osw = new OutputStreamWriter(socket.getOutputStream());
			out = new PrintWriter(new BufferedWriter(osw), true);
			out.println("arc_no_solution");
							
			socket.close();
		}

	    catch(Exception e)
	    {
	    }
	    	    
	}
	
	private void lastConnection()
	{
		Socket socket;
		BufferedReader in;
		PrintWriter out;
		
		try
		{
			socket = new Socket(state.address(), state.port());

			InputStreamReader isr = new InputStreamReader(socket.getInputStream());
			in = new BufferedReader(isr);
			OutputStreamWriter osw = new OutputStreamWriter(socket.getOutputStream());
			out = new PrintWriter(new BufferedWriter(osw), true);
			out.println("arc_last_connection");
							
			socket.close();
										
		}

	    catch(Exception e)
	    {
	    }
	    	    
	}
	
	private void sendMarker(InetAddress addr, int p, int r,String firstAddr, String firstPort, String numInit)
	{
		Socket socket;
		BufferedReader in;
		PrintWriter out;
		
		try
		{
			socket = new Socket(addr, p);
						
			InputStreamReader isr = new InputStreamReader(socket.getInputStream());
			in = new BufferedReader(isr);
			OutputStreamWriter osw = new OutputStreamWriter(socket.getOutputStream());
			out = new PrintWriter(new BufferedWriter(osw), true);
			out.println("arc_marker "+r+" "+state.address()+" "+state.port()+" "+firstAddr+" "+firstPort+" "+numInit );
			
			streamOut.println(state.getName()+" "+"sent "+ "arc_marker "+r+" "+state.address()+" "+state.port()+" "+firstAddr+" "+firstPort+" "+numInit  );
				
			socket.close();			
			
		}

	    catch(Exception e)
	    {
			streamOut.println(state.getName()+" failed sending "+ "arc_marker");
	    }
	    	    
	}

	private void sendMonitor(String message,String firstAddr, String firstPort, String numInit)
	{
		Socket socket;
		BufferedReader in;
		PrintWriter out;
		
		try
		{
			socket = new Socket(state.monitorAddr(), state.monitorPort());
			
			streamOut.println(state.getName()+" "+"Invio " + message);
			
			InputStreamReader isr = new InputStreamReader(socket.getInputStream());
			in = new BufferedReader(isr);
			OutputStreamWriter osw = new OutputStreamWriter(socket.getOutputStream());
			out = new PrintWriter(new BufferedWriter(osw), true);
			out.println(message+" "+state.address()+" "+state.port() +" "+firstAddr+" "+firstPort+" "+numInit);
			
			streamOut.println(state.getName()+" sent "+message+" "+state.address()+" "+state.port() +" "+firstAddr+" "+firstPort+" "+numInit);
				
			socket.close();			
			
		}

	    catch(Exception e)
	    {
			streamOut.println(state.getName()+" failed sending "+message);
	    }
	    	    
	}



}
